/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.codec.text;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.NBTTextComponent;
import net.minecraft.util.text.ScoreTextComponent;
import net.minecraft.util.text.SelectorTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum ITextComponentCodec implements Codec<ITextComponent>
{
    INSTANCE;


    private static <T> Either<String, String> getString(DynamicOps<T> ops, T value) {
        DataResult stringDataResult = ops.getStringValue(value);
        Optional error = stringDataResult.error();
        return error.map(stringPartialResult -> Either.right((Object)stringPartialResult.message())).orElseGet(() -> Either.left(stringDataResult.result().get()));
    }

    private static <T> boolean has(@Nonnull MapLike<T> mapLike, @Nonnull String key) {
        return mapLike.get(key) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> DataResult<Pair<ITextComponent, T>> decode(DynamicOps<T> ops, T input) {
        Optional optional;
        DataResult stringDataResult = ops.getStringValue(input);
        if (!stringDataResult.error().isPresent()) {
            return DataResult.success((Object)Pair.of((Object)new StringTextComponent((String)stringDataResult.result().get()), input));
        }
        DataResult mapLikeDataResult = ops.getMap(input);
        if (!mapLikeDataResult.error().isPresent() && (optional = mapLikeDataResult.result()).isPresent()) {
            Either<String, String> selectorOrError;
            String string;
            StringTextComponent formattableTextComponent;
            MapLike mapLike = (MapLike)optional.get();
            if (ITextComponentCodec.has(mapLike, "text")) {
                Either<String, String> textOrError = ITextComponentCodec.getString(ops, mapLike.get("text"));
                if (!textOrError.left().isPresent()) return DataResult.error((String)((String)textOrError.right().get()));
                formattableTextComponent = new StringTextComponent((String)textOrError.left().get());
            } else if (ITextComponentCodec.has(mapLike, "translate")) {
                Optional stringOptional = ops.getStringValue(mapLike.get("translate")).result();
                if (!stringOptional.isPresent()) return DataResult.error((String)"Missing 'translate', expected to find string");
                string = (String)stringOptional.get();
                if (ITextComponentCodec.has(mapLike, "with")) {
                    Optional withStream = ops.getStream(mapLike.get("with")).result();
                    if (!withStream.isPresent()) return DataResult.error((String)"Expected 'with' to be a JsonArray");
                    Stream stream = (Stream)withStream.get();
                    List list = stream.collect(Collectors.toList());
                    Object[] objects = new Object[list.size()];
                    for (int i = 0; i < objects.length; ++i) {
                        StringTextComponent stringTextComponent;
                        DataResult<Pair<ITextComponent, T>> dataResult = this.decode(ops, list.get(i));
                        Optional error = dataResult.error();
                        if (error.isPresent()) {
                            return DataResult.error((String)((DataResult.PartialResult)error.get()).message());
                        }
                        objects[i] = dataResult.result().get();
                        if (!(objects[i] instanceof StringTextComponent) || !(stringTextComponent = (StringTextComponent)objects[i]).func_150256_b().func_150229_g() || !stringTextComponent.func_150253_a().isEmpty()) continue;
                        objects[i] = stringTextComponent.func_150265_g();
                    }
                    formattableTextComponent = new TranslationTextComponent(string, objects);
                } else {
                    formattableTextComponent = new TranslationTextComponent(string);
                }
            } else if (ITextComponentCodec.has(mapLike, "score")) {
                Optional optionalScoreMap = ops.getMap(mapLike.get("score")).result();
                if (!optionalScoreMap.isPresent()) return DataResult.error((String)"Expected 'score' to be a JsonObject");
                MapLike scoreMap = (MapLike)optionalScoreMap.get();
                if (!ITextComponentCodec.has(scoreMap, "name") || !ITextComponentCodec.has(scoreMap, "objective")) {
                    return DataResult.error((String)"A score component needs at least a name and an objective");
                }
                Either<String, String> stringNameOrError = ITextComponentCodec.getString(ops, scoreMap.get("name"));
                if (stringNameOrError.right().isPresent()) {
                    return DataResult.error((String)((String)stringNameOrError.right().get()));
                }
                Either<String, String> errorOrStringObjective = ITextComponentCodec.getString(ops, scoreMap.get("objective"));
                if (errorOrStringObjective.right().isPresent()) {
                    return DataResult.error((String)((String)errorOrStringObjective.right().get()));
                }
                formattableTextComponent = new ScoreTextComponent((String)stringNameOrError.left().get(), (String)errorOrStringObjective.left().get());
            } else if (ITextComponentCodec.has(mapLike, "selector")) {
                selectorOrError = ITextComponentCodec.getString(ops, mapLike.get("selector"));
                if (!selectorOrError.left().isPresent()) return DataResult.error((String)((String)selectorOrError.right().get()));
                formattableTextComponent = new SelectorTextComponent((String)selectorOrError.left().get());
            } else if (ITextComponentCodec.has(mapLike, "keybind")) {
                selectorOrError = ITextComponentCodec.getString(ops, mapLike.get("keybind"));
                if (!selectorOrError.left().isPresent()) return DataResult.error((String)((String)selectorOrError.right().get()));
                formattableTextComponent = new KeybindTextComponent((String)selectorOrError.left().get());
            } else {
                if (!ITextComponentCodec.has(mapLike, "nbt")) {
                    return DataResult.error((String)("Don't know how to turn " + mapLike + " into a Component"));
                }
                Either<String, String> nbtOrError = ITextComponentCodec.getString(ops, mapLike.get("nbt"));
                if (!nbtOrError.left().isPresent()) return DataResult.error((String)((String)nbtOrError.right().get()));
                string = (String)nbtOrError.left().get();
                boolean interpret = ITextComponentCodec.has(mapLike, "interpret");
                if (interpret) {
                    DataResult interpretResult = ops.getBooleanValue(mapLike.get("interpret"));
                    if (interpretResult.error().isPresent()) {
                        return DataResult.error((String)"Expected 'interpret' to be a boolean");
                    }
                    interpret = (Boolean)interpretResult.result().get();
                }
                if (ITextComponentCodec.has(mapLike, "block")) {
                    Either<String, String> blockOrError = ITextComponentCodec.getString(ops, mapLike.get("block"));
                    if (!blockOrError.left().isPresent()) return DataResult.error((String)((String)blockOrError.right().get()));
                    formattableTextComponent = new NBTTextComponent.Block(string, interpret, (String)blockOrError.left().get());
                } else if (ITextComponentCodec.has(mapLike, "entity")) {
                    Either<String, String> entityOrError = ITextComponentCodec.getString(ops, mapLike.get("entity"));
                    if (!entityOrError.left().isPresent()) return DataResult.error((String)((String)entityOrError.right().get()));
                    formattableTextComponent = new NBTTextComponent.Entity(string, interpret, (String)entityOrError.left().get());
                } else {
                    if (!ITextComponentCodec.has(mapLike, "storage")) {
                        return DataResult.error((String)("Don't know how to turn " + mapLike + " into a Component"));
                    }
                    Either<String, String> storageOrError = ITextComponentCodec.getString(ops, mapLike.get("storage"));
                    if (!storageOrError.left().isPresent()) return DataResult.error((String)((String)storageOrError.right().get()));
                    formattableTextComponent = new NBTTextComponent.Storage(string, interpret, new ResourceLocation((String)storageOrError.left().get()));
                }
            }
            Object extra = mapLike.get("extra");
            if (extra == null) return DataResult.success((Object)Pair.of((Object)formattableTextComponent, input));
            DataResult extraResult = ops.getStream(extra);
            Optional error = extraResult.error();
            if (error.isPresent()) {
                return DataResult.error((String)((DataResult.PartialResult)error.get()).message());
            }
            Stream extraStream = (Stream)extraResult.result().get();
            List entries = extraStream.collect(Collectors.toList());
            if (entries.isEmpty()) {
                return DataResult.error((String)"Unexpected empty array of components");
            }
            for (Object entry : entries) {
                DataResult<Pair<ITextComponent, T>> entryResult = this.decode(ops, entry);
                Optional entryError = entryResult.error();
                if (entryError.isPresent()) {
                    return DataResult.error((String)((DataResult.PartialResult)entryError.get()).message());
                }
                formattableTextComponent.func_230529_a_((ITextComponent)((Pair)entryResult.result().get()).getFirst());
            }
            return DataResult.success((Object)Pair.of((Object)formattableTextComponent, input));
        }
        DataResult streamDataResult = ops.getStream(input);
        Optional error = streamDataResult.error();
        if (error.isPresent()) {
            return DataResult.error((String)("Don't know how to turn " + input + " into a Component"));
        }
        Optional stringOptional = streamDataResult.result();
        if (!stringOptional.isPresent()) return DataResult.error((String)("Don't know how to turn " + input + " into a Component"));
        MarkerTextComponent component = new MarkerTextComponent();
        for (Object entry : ((Stream)stringOptional.get()).collect(Collectors.toList())) {
            DataResult<Pair<ITextComponent, T>> entryResult = this.decode(ops, entry);
            Optional entryError = entryResult.error();
            if (entryError.isPresent()) {
                return DataResult.error((String)((DataResult.PartialResult)entryError.get()).message());
            }
            Optional optional2 = entryResult.result();
            if (!optional2.isPresent()) return DataResult.error((String)("No Component found in " + entry));
            if (component instanceof MarkerTextComponent) {
                component = (IFormattableTextComponent)((Pair)optional2.get()).getFirst();
                continue;
            }
            component.func_230529_a_((ITextComponent)((Pair)optional2.get()).getFirst());
        }
        return DataResult.success((Object)Pair.of((Object)((Object)component), input));
    }

    public <T> DataResult<T> encode(ITextComponent input, DynamicOps<T> ops, T prefix) {
        RecordBuilder mapBuilder = ops.mapBuilder();
        if (!input.func_150253_a().isEmpty()) {
            ListBuilder siblings = ops.listBuilder();
            for (ITextComponent sibling : input.func_150253_a()) {
                DataResult<Object> encodedSibling = this.encode(sibling, ops, ops.empty());
                if (encodedSibling.error().isPresent()) {
                    return DataResult.error((String)((DataResult.PartialResult)encodedSibling.error().get()).message());
                }
                siblings.add(encodedSibling);
            }
            mapBuilder.add("extra", siblings.build(ops.empty()));
        }
        if (input instanceof StringTextComponent) {
            mapBuilder.add("text", ops.createString(((StringTextComponent)input).func_150265_g()));
        } else if (input instanceof TranslationTextComponent) {
            TranslationTextComponent translationTextComponent = (TranslationTextComponent)input;
            mapBuilder.add("translate", ops.createString(((TranslationTextComponent)input).func_150268_i()));
            Object[] formatArgs = translationTextComponent.func_150271_j();
            if (formatArgs != null && formatArgs.length > 0) {
                ListBuilder with = ops.listBuilder();
                for (Object arg : formatArgs) {
                    if (arg instanceof ITextComponent) {
                        DataResult<Object> encodedArg = this.encode((ITextComponent)arg, ops, ops.empty());
                        if (encodedArg.error().isPresent()) {
                            return DataResult.error((String)((DataResult.PartialResult)encodedArg.error().get()).message());
                        }
                        with.add(encodedArg);
                        continue;
                    }
                    with.add(ops.createString(String.valueOf(arg)));
                }
                mapBuilder.add("with", with.build(ops.empty()));
            }
        } else if (input instanceof ScoreTextComponent) {
            ScoreTextComponent scoreTextComponent = (ScoreTextComponent)input;
            RecordBuilder scoreMapBuilder = ops.mapBuilder();
            scoreMapBuilder.add("name", ops.createString(scoreTextComponent.func_179995_g()));
            scoreMapBuilder.add("objective", ops.createString(scoreTextComponent.func_179994_h()));
            mapBuilder.add("score", scoreMapBuilder.build(ops.empty()));
        } else if (input instanceof SelectorTextComponent) {
            mapBuilder.add("selector", ops.createString(((SelectorTextComponent)input).func_179992_g()));
        } else if (input instanceof KeybindTextComponent) {
            mapBuilder.add("keybind", ops.createString(((KeybindTextComponent)input).func_193633_h()));
        } else {
            if (!(input instanceof NBTTextComponent)) {
                return DataResult.error((String)("Don't know how to encode " + input + " as a Component"));
            }
            NBTTextComponent nbtTextComponent = (NBTTextComponent)input;
            mapBuilder.add("nbt", ops.createString(nbtTextComponent.func_218676_i()));
            mapBuilder.add("interpret", ops.createBoolean(nbtTextComponent.func_218677_j()));
            if (nbtTextComponent instanceof NBTTextComponent.Block) {
                mapBuilder.add("block", ops.createString(((NBTTextComponent.Block)nbtTextComponent).func_218683_k()));
            } else if (nbtTextComponent instanceof NBTTextComponent.Entity) {
                mapBuilder.add("entity", ops.createString(((NBTTextComponent.Entity)nbtTextComponent).func_218687_k()));
            } else {
                if (!(nbtTextComponent instanceof NBTTextComponent.Storage)) {
                    return DataResult.error((String)("Don't know to encode " + nbtTextComponent + " as a Component"));
                }
                mapBuilder.add("storage", ops.createString(((NBTTextComponent.Storage)nbtTextComponent).func_229726_k_().toString()));
            }
        }
        return mapBuilder.build(prefix);
    }

    static class MarkerTextComponent
    extends StringTextComponent {
        public MarkerTextComponent() {
            super("");
        }
    }
}

